/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.chatlet.Chatlet;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletErrorResponse;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletInitialRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletObjectFactory;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletPacket;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletProtocol;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletServerPortal;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletTerminateRequest;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ChatletService
implements FcsService,
ChatletProtocol {
    private static final String TRACE_MASKF = "XFCS-SSF";
    private FcsConnection connection;
    private ObjectOutputStream out = null;
    private ObjectInputStream in = null;
    private Socket sock = null;
    private boolean terminate = false;
    private Map chatlets = new HashMap();
    private Object lock = new Object();

    FcsConnection getConnection() {
        return this.connection;
    }

    public void processConnection(FcsConnection connection) {
        Trace.trace(TRACE_MASKF, "-> ChatletService.processConnection()");
        this.connection = connection;
        try {
            this.sock = connection.getSocket();
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.out.flush();
            this.in = new ObjectInputStream(new BufferedInputStream(this.sock.getInputStream()));
            ReceiverThread receiver = new ReceiverThread();
            receiver.setName("Chatlet Svr receiver");
            receiver.start();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Caught IOExcption, cleaning up.");
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("IOException setting up out/in data streams in ChatletService", e);
        }
        Trace.trace(TRACE_MASKF, "<- ChatletService.processConnection()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePacket(ChatletPacket packet) throws IOException {
        Trace.trace(TRACE_MASKF, "writePacket(" + packet + ")");
        Object object = this.lock;
        synchronized (object) {
            if (!this.terminate) {
                this.out.reset();
                packet.writeToStream(this.out);
                this.out.flush();
            } else {
                Trace.trace(TRACE_MASKF, "terminate in progress, ignoring send request.");
            }
        }
    }

    private void writePacket(ChatletPacket packet, ChatletPacket request) throws IOException {
        Trace.trace(TRACE_MASKF, "writePacket(" + packet + "," + request + ")");
        packet.transactionId = request.transactionId;
        packet.chatletId = request.chatletId;
        this.writePacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Trace.trace(TRACE_MASKF, "-> terminate()");
        Map clonedChatlets = Collections.EMPTY_MAP;
        Object object = this.lock;
        synchronized (object) {
            this.terminate = true;
            try {
                Object var5_3;
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    var5_3 = null;
                    this.sock = null;
                    this.in = null;
                    this.out = null;
                }
                var5_3 = null;
                this.sock = null;
                this.in = null;
                this.out = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.sock = null;
                this.in = null;
                this.out = null;
                throw throwable;
            }
            if (!this.chatlets.isEmpty()) {
                clonedChatlets = (Map)((HashMap)this.chatlets).clone();
                this.chatlets.clear();
            }
        }
        Iterator iterator = clonedChatlets.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((ChatletStruct)iterator.next()).chatlet.destroy();
            }
            catch (Exception exception) {}
        }
        Trace.trace(TRACE_MASKF, "<- terminate()");
    }

    class ServiceThread
    extends Thread {
        ChatletStruct chatletStruct;
        ChatletRequest chatletRequest;

        ServiceThread(ChatletStruct chatletStruct, ChatletRequest chatletRequest) {
            this.chatletStruct = chatletStruct;
            this.chatletRequest = chatletRequest;
        }

        public void run() {
            try {
                ChatletResponse response;
                try {
                    Trace.trace(ChatletService.TRACE_MASKF, "Driving request() method for: " + this.chatletRequest);
                    response = this.chatletStruct.chatlet.request(this.chatletRequest);
                }
                catch (Exception e) {
                    response = new ChatletErrorResponse(7);
                    response.errorMessage = "Caught exception driving chatlet's request() method: " + e.toString();
                    Trace.trace(ChatletService.TRACE_MASKF, "Error: " + response.errorMessage);
                    Trace.trace(ChatletService.TRACE_MASKF, e);
                }
                ChatletService.this.writePacket(response, this.chatletRequest);
            }
            catch (IOException e) {
                Trace.trace(ChatletService.TRACE_MASKF, "Caught IOExcption, cleaning up.");
                ChatletService.this.terminate();
            }
        }
    }

    class ReceiverThread
    extends Thread {
        ReceiverThread() {
        }

        public void run() {
            Trace.trace(ChatletService.TRACE_MASKF, "Receiver thread starts");
            while (!ChatletService.this.terminate) {
                try {
                    Trace.trace(ChatletService.TRACE_MASKF, "Receiver thread puts up read");
                    ChatletPacket packet = ChatletObjectFactory.readRequest(ChatletService.this.in);
                    Trace.trace(ChatletService.TRACE_MASKF, "Receiver thread receives: " + packet);
                    if (packet instanceof ChatletInitialRequest) {
                        this.handleInitial((ChatletInitialRequest)packet);
                        continue;
                    }
                    if (packet instanceof ChatletTerminateRequest) {
                        this.handleTerminate((ChatletTerminateRequest)packet);
                        continue;
                    }
                    if (packet instanceof ChatletRequest) {
                        this.handleNormal((ChatletRequest)packet);
                        continue;
                    }
                    ChatletErrorResponse response = new ChatletErrorResponse(6);
                    response.errorMessage = "Inbound packet was not an initial request or a normal request, uknown";
                    Trace.trace(ChatletService.TRACE_MASKF, "Error: " + response.errorMessage);
                    ChatletService.this.writePacket(response, packet);
                }
                catch (Exception e) {
                    Trace.trace(ChatletService.TRACE_MASKF, "Chatlet server receiver catches execption (perhaps during termination processing), cleaning up.");
                    ChatletService.this.terminate();
                }
            }
            Trace.trace(ChatletService.TRACE_MASKF, "Receiver thread ends");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInitial(ChatletInitialRequest request) throws IOException {
            ChatletResponse response;
            block8: {
                Trace.trace(ChatletService.TRACE_MASKF, "packet deemed initial request");
                response = null;
                try {
                    Object obj = Class.forName(request.getChatletClassName()).newInstance();
                    if (obj instanceof Chatlet) {
                        Chatlet theChatlet = (Chatlet)obj;
                        ChatletServerPortal chatletServerPortal = new ChatletServerPortal(ChatletService.this, request.chatletId);
                        theChatlet.setChatletServerPortal(chatletServerPortal);
                        Object object = ChatletService.this.lock;
                        synchronized (object) {
                            ChatletService.this.chatlets.put(new Integer(request.getChatletId()), new ChatletStruct(theChatlet, chatletServerPortal));
                        }
                        response = new ChatletResponse();
                        break block8;
                    }
                    response = new ChatletErrorResponse(4);
                    response.errorMessage = "Named class existed but did not implement the Chatlet interface";
                }
                catch (IllegalAccessException e) {
                    Trace.trace(ChatletService.TRACE_MASKF, "IllegalAccessException creating Chatlet server component.");
                    Trace.trace(ChatletService.TRACE_MASKF, e);
                    response = new ChatletErrorResponse(3);
                    response.errorMessage = e.toString();
                }
                catch (InstantiationException e) {
                    Trace.trace(ChatletService.TRACE_MASKF, "InstantiationException creating Chatlet server component.");
                    Trace.trace(ChatletService.TRACE_MASKF, e);
                    response = new ChatletErrorResponse(2);
                    response.errorMessage = e.toString();
                }
                catch (ClassNotFoundException e) {
                    Trace.trace(ChatletService.TRACE_MASKF, "ClassNotFoundException creating Chatlet server component.");
                    Trace.trace(ChatletService.TRACE_MASKF, e);
                    response = new ChatletErrorResponse(1);
                    response.errorMessage = e.toString();
                }
            }
            ChatletService.this.writePacket(response, request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNormal(ChatletRequest request) throws IOException {
            Trace.trace(ChatletService.TRACE_MASKF, "packet deemed normal request");
            ChatletStruct chatletStruct = null;
            Object object = ChatletService.this.lock;
            synchronized (object) {
                chatletStruct = (ChatletStruct)ChatletService.this.chatlets.get(new Integer(request.getChatletId()));
            }
            if (chatletStruct != null) {
                Trace.trace(ChatletService.TRACE_MASKF, "popping service thread");
                ServiceThread serviceThread = new ServiceThread(chatletStruct, request);
                serviceThread.setName("Chatlet request service thread");
                serviceThread.start();
            } else {
                ChatletErrorResponse response = new ChatletErrorResponse(5);
                response.errorMessage = "Chatlet id specified in request does not refer to a known Chatlet instance";
                Trace.trace(ChatletService.TRACE_MASKF, "Error: " + response.errorMessage);
                ChatletService.this.writePacket(response, request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTerminate(ChatletRequest request) throws IOException {
            Trace.trace(ChatletService.TRACE_MASKF, "packet deemed terminate request");
            ChatletResponse response = null;
            ChatletStruct chatletStruct = null;
            Object object = ChatletService.this.lock;
            synchronized (object) {
                chatletStruct = (ChatletStruct)ChatletService.this.chatlets.remove(new Integer(request.getChatletId()));
            }
            if (chatletStruct != null) {
                try {
                    chatletStruct.chatlet.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                response = new ChatletResponse();
            } else {
                response = new ChatletErrorResponse(8);
                response.errorMessage = "Specified ChatletId did not reference a valid Chatlet object";
            }
            ChatletService.this.writePacket(response, request);
        }
    }

    static class ChatletStruct {
        Chatlet chatlet;
        ChatletServerPortal chatletServerPortal;

        ChatletStruct(Chatlet chatlet, ChatletServerPortal chatletServerPortal) {
            this.chatlet = chatlet;
            this.chatletServerPortal = chatletServerPortal;
        }
    }
}

